<?php

include 'vendor/autoload.php';
require_once 'dbconfig.php';

class USER {

    protected $twilio_sid;
    protected $twilio_token;
    protected $twilio_number;
    protected $send_sms_messages;
    protected $sms_service_sid;
    private $conn;

    public function __construct() {
        
        global $twilio_sid, $twilio_token, $twilio_number, $send_sms_messages, $sms_service_sid;
        $this->twilio_sid = $twilio_sid;
        $this->twilio_token = $twilio_token;
        $this->twilio_number = $twilio_number;
        $this->sms_service_sid = $sms_service_sid;
        $this->send_sms_messages = $send_sms_messages;
        
        $database = new Database();
        $db = $database->dbConnection();
        $this->conn = $db;
    }

    public function runQuery($sql) {
        $stmt = $this->conn->prepare($sql);
        return $stmt;
    }

    public function lasdID() {
        $stmt = $this->conn->lastInsertId();
        return $stmt;
    }

    public function create($pishure, $fname, $mname, $lname, $uname, $upass, $phone, $email, $type, $work, $acc_no, $addr, $sex, $dob, $marry, $t_bal, $a_bal) {
        try {
            $upass = md5($upass);
            $stmt = $this->conn->prepare("INSERT INTO account(pishure,fname,mname,lname,uname,upass,phone,email,type,work,acc_no,addr,sex,dob,marry,t_bal,a_bal) 
			                                             VALUES(:pishure, :fname, :mname, :lname, :uname, :upass, :phone, :email, :type, :work, :acc_no, :addr, :sex, :dob, :marry, :t_bal, :a_bal)");
            $stmt->bindparam(":pishure", $pishure);
            $stmt->bindparam(":fname", $fname);
            $stmt->bindparam(":mname", $mname);
            $stmt->bindparam(":lname", $lname);
            $stmt->bindparam(":uname", $uname);
            $stmt->bindparam(":upass", $upass);
            $stmt->bindparam(":phone", $phone);
            $stmt->bindparam(":email", $email);
            $stmt->bindparam(":type", $type);
            $stmt->bindparam(":work", $work);
            $stmt->bindparam(":acc_no", $acc_no);
            $stmt->bindparam(":addr", $addr);
            $stmt->bindparam(":sex", $sex);
            $stmt->bindparam(":dob", $dob);
            $stmt->bindparam(":marry", $marry);
            $stmt->bindparam(":t_bal", $t_bal);
            $stmt->bindparam(":a_bal", $a_bal);
            $stmt->execute();
            return $stmt;
        } catch (PDOException $ex) {
            echo $ex->getMessage();
        }
    }

    public function transfer($email, $amount, $acc_no, $acc_name, $bank_name, $swift, $routing, $type, $remarks, $cout, $transtype) {
        try {

            $stmt = $this->conn->prepare("INSERT INTO transfer(email,amount,acc_no,acc_name,bank_name,type,swift,routing,remarks,cout,transtype) 
			                                             VALUES(:email, :amount, :acc_no, :acc_name, :bank_name, :type, :swift, :routing, :remarks, :cout, :transtype)");
            $stmt->bindparam(":email", $email);
            $stmt->bindparam(":amount", $amount);
            $stmt->bindparam(":acc_no", $acc_no);
            $stmt->bindparam(":acc_name", $acc_name);
            $stmt->bindparam(":bank_name", $bank_name);
            $stmt->bindparam(":type", $type);
            $stmt->bindparam(":swift", $swift);
            $stmt->bindparam(":routing", $routing);
            $stmt->bindparam(":remarks", $remarks);
            $stmt->bindparam(":cout", $cout);
            $stmt->bindparam(":transtype", $transtype);
            $stmt->execute();
            return $stmt;
        } catch (PDOException $ex) {
            echo $ex->getMessage();
        }
    }

    public function temp($email, $amount, $acc_no, $acc_name, $bank_name, $swift, $routing, $type, $remarks, $cout, $transtype) {
        try {

            $stmt = $this->conn->prepare("INSERT INTO temp_transfer(email,amount,acc_no,acc_name,bank_name,type,swift,routing,remarks,cout,transtype) 
			                                             VALUES(:email, :amount, :acc_no, :acc_name, :bank_name, :type, :swift, :routing, :remarks, :cout, :transtype)");
            $stmt->bindparam(":email", $email);
            $stmt->bindparam(":amount", $amount);
            $stmt->bindparam(":acc_no", $acc_no);
            $stmt->bindparam(":acc_name", $acc_name);
            $stmt->bindparam(":bank_name", $bank_name);
            $stmt->bindparam(":type", $type);
            $stmt->bindparam(":swift", $swift);
            $stmt->bindparam(":routing", $routing);
            $stmt->bindparam(":remarks", $remarks);
            $stmt->bindparam(":cout", $cout);
            $stmt->bindparam(":transtype", $transtype);
            $stmt->execute();
            return $stmt;
        } catch (PDOException $ex) {
            echo $ex->getMessage();
        }
    }

    public function ticket($tc, $sender_name, $sub, $msg) {
        try {

            $stmt = $this->conn->prepare("INSERT INTO ticket(tc,sender_name,subject,msg) 
			                                             VALUES(:tc, :sender_name, :subject, :msg)");
            $stmt->bindparam(":tc", $tc);
            $stmt->bindparam(":sender_name", $sender_name);
            $stmt->bindparam(":subject", $sub);
            $stmt->bindparam(":msg", $msg);
            $stmt->execute();
            return $stmt;
        } catch (PDOException $ex) {
            echo $ex->getMessage();
        }
    }

    public function message($sender_name, $reci_name, $subject, $msg) {
        try {

            $stmt = $this->conn->prepare("INSERT INTO message(sender_name,reci_name,subject,msg) 
			                                             VALUES(:sender_name, :reci_name, :subject, :msg)");

            $stmt->bindparam(":sender_name", $sender_name);
            $stmt->bindparam(":reci_name", $reci_name);
            $stmt->bindparam(":subject", $subject);
            $stmt->bindparam(":msg", $msg);
            $stmt->execute();
            return $stmt;
        } catch (PDOException $ex) {
            echo $ex->getMessage();
        }
    }

    public function delaccount($id) {
        try {

            $stmt = $this->conn->prepare("DELETE FROM account WHERE id = :id");

            $stmt->bindparam(":id", $id);

            $stmt->execute();
            return $stmt;
        } catch (PDOException $ex) {
            echo $ex->getMessage();
        }
    }

    public function update($email, $phone, $addr) {
        $update = "UPDATE account SET
				email = :email,
				phone = :phone,
				addr = :addr,
				
				WHERE id = :id";
        try {
            $stmt = $this->conn->prepare($update);

            $stmt->bindparam(':email', $_POST['email'], PDO::PARAM_STR);
            $stmt->bindparam(':phone', $_POST['phone'], PDO::PARAM_STR);
            $stmt->bindparam(':addr', $_POST['addr'], PDO::PARAM_STR);

            $stmt->execute();
            return $stmt;
        } catch (PDOException $ex) {
            echo $ex->getMessage();
        }
    }

    public function bal($t_bal) {
        $update = "UPDATE account SET
				t_bal = :t_bal,
				
				WHERE id = :id";
        try {
            $stmt = $this->conn->prepare($update);

            $stmt->bindparam(':t_bal', $_POST['t_bal'], PDO::PARAM_STR);

            $stmt->execute();
            return $stmt;
        } catch (PDOException $ex) {
            echo $ex->getMessage();
        }
    }

    public function login($uname, $upass) {
        try {
            $stmt = $this->conn->prepare("SELECT * FROM account WHERE uname=:uname");
            $stmt->execute(array(":uname" => $uname));
            $userRow = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($stmt->rowCount() == 1) {
                if ($userRow['upass'] == ($upass)) {
                    $_SESSION['userSession'] = $userRow['uname'];
                    return true;
                } else {
                    header("Location: login.php?error");
                    exit;
                }
            } else {
                header("Location: login.php?error");
                exit;
            }
        } catch (PDOException $ex) {
            echo $ex->getMessage();
        }
    }

    public function is_logged_in() {
        if (isset($_SESSION['userSession'])) {
            return true;
        }
    }

    public function redirect($url) {
        header("Location: $url");
    }

    public function logout() {
        session_destroy();
        $_SESSION['userSession'] = false;
    }

     function send_mail($email, $messag, $subject) {
        require_once('mailer/class.phpmailer.php');
        $mail = new PHPMailer();
        $mail->IsSMTP();
        $mail->SMTPDebug = 0;
        $mail->SMTPAuth = true;
        $mail->SMTPSecure = "";
        $mail->Host = "secure.theubaonline.com";
        $mail->Port = 26;
        $mail->AddAddress($email);
        $mail->Username = "alert@secure.theubaonline.com";
        $mail->Password = "@secure.theubaonline.com";
        $mail->SetFrom('alert@secure.theubaonline.com', 'UBA ONLINE');
        $mail->AddReplyTo("alert@secure.theubaonline.com", "UBA ONLINE");
        $mail->Subject = $subject;
        $mail->MsgHTML($messag);
        $mail->Send();
    }

    function otp($to, $msg) {
        if ($this->send_sms_messages == 1) {
            $client = new Twilio\Rest\Client($this->twilio_sid, $this->twilio_token);
            try {
                $message = $client->messages->create(
                    '+' . $to,
                    array(
                        //'from' => $this->twilio_number,
                        'messagingServiceSid' => $this->sms_service_sid,
                        'body' => $msg
                    )
                );
            }catch(Exception $e){
                echo $e->getCode() . ' : ' . $e->getMessage()."<br>";
            }
            return "SMS Sent";
        }
        return "SMS Not Configured";
    }

}
?>